<?php 

    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/includeBase.php";
    include "../classi/Comunicazione.php";    
    include "../template/stile.php";
    
    include "include/controlloLogin.php";
    
    if(isset($_GET["id"])) {
        $comunicazione = new Comunicazione($geecomDb,filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
        $comunicazione->caricaDatiDalDatabase();
        
        if($comunicazione->getTipo()=="comunicazione") {        
            $tipoComunicazionePlurale  = "Comunicazioni";
            $fraseModifcaComunicazione = "Modifica comunicazione ".$comunicazione->getOggetto();
        }
        else if($comunicazione->getTipo()=="segnalazione") {
            $tipoComunicazionePlurale = "Segnalazioni";
            $fraseModifcaComunicazione = "Gestisci segnalazione ".$comunicazione->getOggetto();
        }
        else if($comunicazione->getTipo()=="ticket") {
            $tipoComunicazionePlurale = "Ticket";
            $fraseModifcaComunicazione = "Gestisci ticket ".$comunicazione->getOggetto();
        }
    }
    else {
        $tipoComunicazionePlurale = "Comunicazioni";
    }
    
    $status = (isset($_GET["status"])) ? filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT) : 0;
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "include/cssBaseAreaAmministrativa.php";
        ?>
        <title>Geecom Admin - Creazione comunicazione</title>
    </head>
    <body>
    
    <header>
        <?php 
            include "include/barraSuperiore.php";

            include "include/header.php";

            include "include/barraMenu.php";
        ?>
    </header>

    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            <form action="../controller/controllerComunicazioni.php" method="post" name="formModificaComunicazioni">
                <div class="row py-4">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Comunicazione inviata
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        else if($status==250) {
                             echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Rivedi la comunicazione prima dell'invio
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }                        
                    ?>
                    
                    <input type="text" class="d-none" name="operazione" id="operazione" value="<?php echo((isset($comunicazione) ? "modifica" : "crea")); ?>">
                    <input type="text" class="d-none" name="id" value="<?php echo((isset($comunicazione) ? $comunicazione->getId() : "0")); ?>">
                    
                    <div class="col-lg-8 py-4">
                        <div class="form-row justify-content-between mb-3">
                            <div class="col-auto d-flex">
                                <nav aria-label="breadcrumb" class="align-self-center">
                                    <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                        <li class="breadcrumb-item"><a href="home.php">Home</a></li>
                                        <li class="breadcrumb-item"><a href="gestioneComunicazioni.php?tipo=<?php echo(isset($comunicazione) ? $comunicazione->getTipo() : "comunicazione") ?>"><?php echo $tipoComunicazionePlurale ?></a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo(isset($comunicazione) ? $fraseModifcaComunicazione : "Crea una nuova comunicazione") ?></li>
                                    </ol>
                                </nav>
                            </div>
                            <div class="col-auto text-right">
                                <?php 
                                    if(isset($comunicazione) && $comunicazione->getTipo()=="comunicazione") {
                                ?>
                                    <a class="btn btn-primary mr-1" href="creaComunicazione.php">Crea nuova <i class="fas fa-plus ml-2"></i></a>
                                <?php      
                                    }
                                ?>
                                <a class="btn btn-outline-primary" href="gestioneComunicazioni.php?tipo=<?php echo(isset($comunicazione) ? $comunicazione->getTipo() : "comunicazione") ?>"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                            </div>
                        </div>
                        
                        <div class="card mb-4 box-shadow-lite">
                            <div class="card-body py-3">
                                    <?php 
                                        if(isset($comunicazione) && $comunicazione->getTipo()=="ticket") {
                                            ?><label class="mr-2" for="titolo-articolo"><strong>Oggetto: </strong></label><?php
                                            echo $comunicazione->getOggetto();
                                        }
                                        else {
                                    ?>
                                            <div class="row">
				                <div class="form-group col-md-8">
		                            	     <label for="titolo-articolo">Oggetto</label>
		                                    <input  type="text" class="form-control form-control-lg" id="titolo-articolo" name="oggetto" value="<?php echo((isset($comunicazione)? $comunicazione->getOggetto() : ""))?>" placeholder="Oggetto della comunicazione" <?php echo((isset($comunicazione) && $comunicazione->getStato()=="inviata")? "disabled" : "")?>>
				                </div>
                                                
                                                <?php 
                                                    if(!isset($comunicazione)) {
                                                ?>
                                                        <div class="form-group col-md-2">
                                                            <label for="select1" class="d-block">Invia email</label> 
                                                            <input type="checkbox" name=inviaEmail class="js-switch" value="si" />
                                                        </div>

                                                        <div class="form-group col-md-2">
                                                            <label for="select1" class="d-block">Invia notifica</label> 
                                                            <input type="checkbox" name=inviaNotifica class="js-switch" value="si" />
                                                        </div>
                                                <?php
                                                    }
                                                    else if(!isset($comunicazione) || (isset($comunicazione) && $comunicazione->getTipo()=="comunicazione" && $comunicazione->getStato()!="inviata")) {
                                                ?>
                                                        <div class="form-group col-md-2">
                                                            <label for="select1" class="d-block">Invia email</label> 
                                                            <input type="checkbox" name=inviaEmail class="js-switch" value="si" <?php echo(($comunicazione->getInviaMail()=="si") ? "CHECKED":"") ?> />
                                                        </div>

                                                        <div class="form-group col-md-2">
                                                            <label for="select1" class="d-block">Invia notifica</label> 
                                                            <input type="checkbox" name=inviaNotifica class="js-switch" value="si" <?php echo(($comunicazione->getInviaNotifica()=="si") ? "CHECKED":"") ?> />
                                                        </div>
                                                <?php
                                                    }
                                                    else if(isset($comunicazione) && $comunicazione->getTipo()=="comunicazione" && $comunicazione->getStato()=="inviata") {
                                                ?>
                                                        <div class="form-group col-md-2">
                                                            <label for="select1" class="d-block">Invia email</label> 
                                                            <?php echo $comunicazione->getInviaMail() ?>
                                                        </div>

                                                        <div class="form-group col-md-2">
                                                            <label for="select1" class="d-block">Invia notifica</label> 
                                                            <?php echo $comunicazione->getInviaNotifica() ?>
                                                        </div>
                                                <?php
                                                    }
                                                ?>
                                            </div>
                                    <?php
                                        }
                                    ?>
                                
                                <div class="form-row">
                                    <?php 
                                        if(!isset($comunicazione) || $comunicazione->getTipo()!="ticket") {
                                    ?>
                                    <div class="form-group col-md-8">
                                        <label class="d-block" for="titolo-articolo">Gruppi</label>
                                        <select class="selectpicker" data-width="100%" name="gruppi[]" multiple <?php echo(((isset($comunicazione) && $comunicazione->getStato()=="inviata")? "disabled" : ""))?>>
                                            <?php
                                                $arrayGruppiAssociati = array();
                                                if(isset($comunicazione)) {
                                                    $queryCategorieAssociate ="SELECT idGruppoDestinatario FROM geecAd_gruppiDestinatari WHERE idComunicazione={$comunicazione->getId()}";
                                                    $risCategorie = $geecomDb->eseguiQueryLettura($queryCategorieAssociate);
                                                    $arrayGruppiAssociati = array();
                                                    while($gruppoTrovato = $risCategorie->fetch_assoc()) {
                                                        $arrayGruppiAssociati[count($arrayGruppiAssociati)] = $gruppoTrovato["idGruppoDestinatario"];
                                                    }
                                                }

                                                $queryNomiTag = "SELECT * FROM geec_gruppi";
                                                $risNomi = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                while($gruppo = $risNomi->fetch_assoc()) {
                                                    if(isset($comunicazione) && in_array($gruppo["id"], $arrayGruppiAssociati)) {
                                                        $selezionato  = "selected";
                                                    }
                                                    else {
                                                        $selezionato  = "";
                                                    }
                                                    echo"<option value=\"{$gruppo["id"]}\" $selezionato >{$gruppo["nome"]}</option>";
                                                }
                                           ?>
                                        </select>
                                    </div>
                                    <?php
                                        }
                                        
                                        if(!isset($comunicazione) || $comunicazione->getTipo()=="comunicazione") {
                                    ?>
                                        <div class="form-group col-md-4">
                                            <label class="d-block" for="titolo-articolo">Template mail</label>
                                            <select class="form-control" id="idTemplate" name="template" onchange="mostraDivLegatiAlTema()">
                                                <?php
                                                    $query    = "SELECT * FROM geec_templateEmail WHERE id>1";
                                                    $risQueryTemplate = $geecomDb->eseguiQueryLettura($query);
                                                    while($template = $risQueryTemplate->fetch_assoc()) {
                                                        if(isset($comunicazione) && $comunicazione->getTemplate()==$template["id"]) {
                                                            echo"<option value=\"{$template["id"]}\" selected>{$template["nome"]} </option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"{$template["id"]}\" >{$template["nome"]} </option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                    <?php
                                        }
                                    ?>
                                </div>
                                
                                <div class="form-group">
                                    <?php 
                                        if(isset($comunicazione) && $comunicazione->getTipo()=="ticket") {
                                            echo"<hr>";
                                            echo($comunicazione->getTesto());
                                        }
                                        else if(isset($comunicazione)) {
                                    ?>
                                            <div id="componentiEmail" class="wrapper-sezioni-pagina">
                                                <?php
                                                    $componentiModificabili = ($comunicazione->getStato()=="inviata") ? false : true;
                                                    $comunicazione->stampaComponenti($componentiModificabili);
                                                ?>
                                            </div>
                                            <button type="button" class="btn btn-success btn-block" data-toggle="modal" data-target="#aggiungi-componente"><i class="fas fa-plus"></i> Aggiungi un componente</button>
                                    <?php
                                        }
                                    ?>
                                </div>
                            </div>
                            
                            <?php
                                if(!isset($comunicazione)) {
                            ?>
                            <div class="card-body wrapper-sezioni-pagina">
                                <button type="submit" class="btn btn-primary float-right mt-3 mr-2"><i class="fas fa-check"></i> Salva</button>
                            </div>
                            <?php
                                }
                                else if(($comunicazione->getTipo()=="comunicazione" && $comunicazione->getStato()!="inviata")) {
                            ?>
                            <div class="card-body wrapper-sezioni-pagina">
                                <button type="button" class="btn btn-success float-right mt-3" onclick="inviaComunicazione()" <?= ($comunicazione->getInviaMail()!="si" && $comunicazione->getInviaNotifica()!="si") ? "disabled" : "" ?>><i class="fas fa-paper-plane"></i> Invia</button>
                                <button type="submit" class="btn btn-primary float-right mt-3 mr-2"><i class="fas fa-check"></i> Salva</button>
                            </div>
                            <?php
                                }
                                if(isset($comunicazione) && $comunicazione->getTipo()=="comunicazione" && $comunicazione->getStato()=="inviata") {
                            ?>
                            <div class="card-body wrapper-sezioni-pagina">
                                <button type="button" class="btn btn-success float-right mt-3" onclick="inviaComunicazioneNuovamente()"><i class="fas fa-paper-plane"></i> Invia di nuovo</button>
                            </div>
                            <?php
                                }
                            ?>
                        </div>
                    </div><!--/Colonna principale -->
                    <!-- Colonna principale -->
                    
                    <!--Colonna secondaria -->
                    <div class="col-lg-4 py-4 align-self-start sticky-top">
                        <?php
                            if(isset($comunicazione) && $comunicazione->getTipo()=="comunicazione" && $comunicazione->getStato()=="inviata") {
                        ?>
                            <div class="btn-group d-flex mb-3" role="group" aria-label="Basic example">
                                <button type="button" class="btn btn-success w-100" onclick="inviaComunicazioneNuovamente()"><i class="fas fa-paper-plane mr-2"></i>Invia di nuovo</button>
                            </div>
                        <?php
                            }
                            else if(isset($comunicazione) && $comunicazione->getTipo()=="ticket") {
                                
                            }
                            else if(!isset($comunicazione)) {
                        ?>
                            <div class="btn-group d-flex mb-3" role="group" aria-label="Basic example">
                                <button type="submit" class="btn btn-primary w-100"><i class="fas fa-check mr-2"></i>Salva</button>
                            </div>
                        <?php
                            }
                            else {
                        ?>
                            <div class="btn-group d-flex mb-3" role="group" aria-label="Basic example">
                                <button type="submit" class="btn btn-primary w-100"><i class="fas fa-check mr-2"></i>Salva</button>
                                <button type="button" class="btn btn-success w-100" onclick="inviaComunicazione()" <?= ($comunicazione->getInviaMail()!="si" && $comunicazione->getInviaNotifica()!="si") ? "disabled" : "" ?>><i class="far fa-paper-plane mr-2"></i>Invia</button>
                            </div>
                        <?php
                            }
                        ?>
                        <div class="clearfix"></div>
                        <?php
                            if(isset($comunicazione) && $comunicazione->getTipo()!="ticket") {
                                $analisi       = $comunicazione->eseguiAnalisi();
                                $caratteriOggetto = strlen($comunicazione->getOggetto());
                                $caratteriTesto   = $comunicazione->contaTestoComunicazione();
                        ?>
                            <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                                <div class="card-header collapsed" data-toggle="collapse" href="#SEO">
                                    <a class="card-title">
                                        Efficacia <?php echo $analisi["esito"] ?>
                                    </a>
                                </div>
                                <div id="SEO" class="collapse show p-0">
                                    <div class="card-body p-0">
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item <?php echo(($caratteriOggetto<20) ? "text-danger" : "text-success") ?>"><strong>Oggetto:</strong> <?php echo $caratteriOggetto ?> caratteri </li>
                                            <li class="list-group-item <?php echo(($caratteriTesto<50) ? "text-danger" : "text-success") ?>"><strong>Testo:</strong> <?php echo $caratteriTesto ?> caratteri </li>
                                            <?php 
                                                if(count($analisi["suggerimenti"])==0) {
                                                    echo"<li class=\"list-group-item text-success\"> <i class=\"far fa-thumbs-up\"></i> Nessun suggerimento, bravo! </li>";
                                                }
                                                else {
                                                    foreach($analisi["suggerimenti"] as $suggerimento) {
                                                        echo"<li class=\"list-group-item\">$suggerimento </li>";
                                                    }
                                                }
                                            ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        <?php
                            }
                            
                            if(isset($comunicazione) && $comunicazione->getTipo()=="comunicazione" && $comunicazione->getInviaMail()=="si") {
                                $analisi       = $comunicazione->eseguiAnalisi();
                                $caratteriOggetto = strlen($comunicazione->getOggetto());
                                $caratteriTesto   = strlen($comunicazione->getTesto());
                        ?>
                            <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                                <div class="card-header collapsed" data-toggle="collapse" href="#antePrima">
                                    <a class="card-title">
                                        Anteprima email
                                    </a>
                                </div>
                                <div id="antePrima" class="collapse show">
                                    <p class="small text-muted m-3">Nota: l'anteprima ha una funzione indicativa, effettua un invio di prova per verifcare l'aspetto definitivo dell'email</p>
                                    <hr>
                                    <iframe src="../controller/controllerComunicazioni.php?id=<?= $comunicazione->getId() ?>&operazione=generaCodice" width="100%" height="700" frameBorder="0"></iframe>
                                </div>
                            </div>
                        <?php
                            }
                            
                            if(isset($comunicazione) && $comunicazione->getTipo()=="comunicazione" && $comunicazione->getInviaMail()=="si" && $comunicazione->getStato()!="inviata") {
                                $analisi       = $comunicazione->eseguiAnalisi();
                                $caratteriOggetto = strlen($comunicazione->getOggetto());
                                $caratteriTesto   = strlen($comunicazione->getTesto());
                        ?>
                            <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                                <div class="card-header collapsed" data-toggle="collapse" href="#divAutore">
                                    <a class="card-title">
                                        Invia mail di prova
                                    </a>
                                </div>
                                <div id="divAutore" class="collapse show">
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label>Indirizzo</label>
                                            <input type="text" class="form-control" id="mailDestinatario" placeholder="Email destinatario">
                                        </div>
                                        <button type="button" class="btn btn-outline-primary btn-block" onclick="inviaMailTest()"><i class="fas fa-paper-plane mr-2"></i>Invia</button>
                                    </div>
                                </div>
                            </div>
                        <?php
                            }
                            else if(isset($comunicazione) && $comunicazione->getTipo()=="comunicazione" && $comunicazione->getStato()=="inviata") {
                        ?>
                            <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                                <div class="card-header collapsed" data-toggle="collapse" href="#reportInvio">
                                    <a class="card-title">
                                        Report invio
                                    </a>
                                </div>
                                <div id="reportInvio" class="collapse show p-0">
                                    <div class="card-body p-0">
                                        <?php 
                                            if($comunicazione->getStato()=="inviata") {
                                                if($comunicazione->getInviaNotifica()=="si" && $comunicazione->getInviaMail()=="si") {
                                                    $tipoInvio = "email e notifica";
                                                }
                                                else if($comunicazione->getInviaNotifica()=="si") {
                                                    $tipoInvio = "notifica";
                                                }
                                                else if($comunicazione->getInviaMail()=="si") {
                                                    $tipoInvio = "email";
                                                }
                                        ?>
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item">Inviata tramite <?= $tipoInvio ?> il <?php echo date("d/m/Y H:i",strtotime($comunicazione->getDataInvio()))?></li>
                                            <?php 
                                                if($comunicazione->getInviaMail()=="si") {
                                            ?>
                                            <li class="list-group-item text-success"> <i class="far fa-smile"></i> <?php echo($comunicazione->getMailInviate()) ?> mail consegnate </li>
                                            <?php 
                                                }
                                                
                                                if($comunicazione->getMailNonInviate()>0) {
                                            ?>
                                            <li class="list-group-item text-danger"> <i class="far fa-meh"></i> <?php echo($comunicazione->getMailNonInviate()) ?> mail non consegnate </li>
                                            <?php 
                                                }
                                            ?>
                                        </ul>
                                        <?php
                                            }
                                            else {
                                        ?>
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item">La comunicazione non è stata ancora inviata</li>                                            </li>
                                        </ul>
                                        <?php
                                            }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        <?php
                            }
                            
                            if(isset($comunicazione) && $comunicazione->getTipo()=="ticket") {
                                
                                if($comunicazione->getPriorita()=="alta") {
                                    $classeCondizionale = "badge-danger";
                                }
                                else if($comunicazione->getPriorita()=="alta") {
                                    $classeCondizionale = "badge-warning";
                                }
                                else {
                                    $classeCondizionale = "badge-info";
                                }
                        ?>
                                <div class="card mb-3 rounded-0 box-shadow-lite">
                                    <div class="card-header">
                                        <div class="badge p-2 <?php echo $classeCondizionale ?>">
                                            Priorità <?php echo $comunicazione->getPriorita() ?>
                                        </div>
                                        <div class="badge p-2 <?php echo (($comunicazione->getStato()=="aperto") ? "badge-warning" : "badge-success") ?>">
                                            <?php echo ucfirst($comunicazione->getStato()) ?>
                                        </div>
                                    </div>
                                </div>
                        <?php
                            }
                        ?>
                        </form>
            
                    </div><!--/Colonna secondaria -->
                </form>

            </div>
            <?php 
                if(isset($comunicazione) && $comunicazione->getTipo()=="ticket") {
            ?>
            <div class="row">
                <div class="col py-4">
                    <div class="card mb-4 box-shadow-lite">
                        <div class="card-header">
                            <span class="card-title mr-2"> Risposte al ticket</span>
                            <a href="#" data-toggle="modal" data-target="#modalRispostaTicket" class="btn btn-sm btn-primary" >
                                Aggiungi risposta<i class="fas fa-plus ml-2"></i>
                            </a>
                        </div>

                        <!-- tabella -->
                        <div class="table-responsive">
                            <table class="table table-hover table-condensed">
                                <thead>
                                    <tr>
                                        <th>Data</th>
                                        <th>Autore</th>
                                        <th>Testo</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php 
                                    $risultatiPerPagina = 15;// <-- cambiare questo valore per modificare il numero di risultati per pagina
                                    if(isset($_GET["cerca"])) {
                                        $queryNumeroGruppi = "SELECT COUNT(*) FROM geecAd_risposteTicket WHERE oggetto LIKE '%{$_GET["cerca"]}%'";
                                    }
                                    else {
                                        $queryNumeroGruppi = "SELECT COUNT(*) FROM geecAd_risposteTicket";
                                    }
                                    $risNumGruppi = $geecomDb->eseguiQueryLettura($queryNumeroGruppi);
                                    $numGruppi = $risNumGruppi->fetch_array(MYSQLI_NUM);

                                    if(isset($_GET["pag"])) {
                                        $limSup = $risultatiPerPagina * $_GET["pag"];
                                        $limInf = $limSup - $risultatiPerPagina;
                                        $queryGruppi="SELECT * FROM geecAd_risposteTicket WHERE idTicket={$comunicazione->getId()} ORDER BY id DESC LIMIT $limInf, $limSup";
                                        $paginaCorrente = $_GET["pag"];
                                    }
                                    else {
                                        $queryGruppi="SELECT * FROM geecAd_risposteTicket WHERE idTicket={$comunicazione->getId()} ORDER BY id DESC LIMIT $risultatiPerPagina";
                                        $paginaCorrente = 1;
                                    }

                                    $result = $geecomDb->eseguiQueryLettura($queryGruppi);
                                    while($rispostaTicket=$result->fetch_assoc()) {

                                        if(strlen($rispostaTicket["testo"])>100) {
                                            $testoTroncato = substr($rispostaTicket["testo"], 0, 100)."...";
                                        }
                                        else {
                                            $testoTroncato = $rispostaTicket["testo"];
                                        }

                                        $dataCreazione = date("d/m/Y H:i",strtotime($rispostaTicket["dataCreazione"]));
                                        echo"<tr>
                                            <td>$dataCreazione</td>
                                            <td>{$rispostaTicket["autore"]}</td>
                                            <td>$testoTroncato</td>
                                          </tr>";
                                    }
                                ?>
                                </tbody>
                            </table>
                        </div><!-- /tabella -->
                    </div>
                </div>
            </div>
            <?php
                }
            ?>
        </div>
    </main>

    <?php 
        include "include/footer.php";
        
        include "include/modal/cambiaPassword.php";
        
        include "include/modal/modalMenuComponenti.php";
        
        include "include/modal/operazioneCompletata.php";
        
        if(isset($comunicazione) && $comunicazione->getId()!=0) {
            include "include/modal/aggiungiComponenteComunicazioni.php";
        }
    ?>
        
        <div class="modal fade" id="modalEliminaComponente" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Eliminare il componente?</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex flex-row justify-content-center">
                            <img id="immagineComponenteDaEliminare" class="thumb d-none d-lg-block" src="">
                            <div class="align-self-center">
                                <span class="mr-3 align-self-center text-primary"><em id="nomeComponenteDaEliminare"></em></span>
                                <div id="nomeElementoDaEliminare"></div>
                            </div>
                        </div>
                        <input type="text" class="d-none" id="componenteDaEliminare">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneComponente()"><i class="fas fa-check"></i> Elimina</button>
                    </div>
                </div>
            </div>
        </div>
        
	<!-- MODALS  -->
	<div class="modal fade" id="modalRispostaTicket" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Aggiungi risposta al ticket</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form name="formAggiungiRisposta" action="../controller/controllerComunicazioni.php" method="post">
                            <textarea class="tiny" name="testo"></textarea>
                            <input type="text" class="d-none" name="operazione" value="rispondiTicketAmministratore">
                            <input type="text" class="d-none" name="id" value="<?php echo(isset($comunicazione) ? $comunicazione->getId() : 0) ?>">
                        </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" id="bottoneModalAggiungiRispostaTicket" class="btn btn-primary btn-sm" onclick="aggiungiRispostaTicket()"><i class="fas fa-check"></i> Aggiungi risposta</button>
                    </div>
                </div>
            </div>
        </div>
        
        <?php
            // se la comunicazione è presente stampo le modal di modifica dei componenti
        
            if(isset($comunicazione)) {
                $queryComponentiDaMostrare = "SELECT c.id, c.idComponente, cm.nome, c.posizione, c.testo, c.altreOpzioni FROM geecAd_composizioneComunicazioni AS c JOIN geecAd_componenti AS cm ON c.idComponente=cm.id WHERE idComunicazione={$comunicazione->getId()} ORDER BY c.posizione ASC";
                $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);

                $arrayOpzioniAllineamento = array(""=>"Sinistra","text-center"=>"Centro","text-right"=>"Destra");

                while($componente = $risComponenti->fetch_assoc()) {

                    ?>
                    <div class="modal fade" id="configuraComponente<?php echo $componente["id"]; ?>" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">Componente <?php echo $componente["nome"] ?></h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                                    <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form name="formAggiornaComponente<?php echo $componente["id"]; ?>" action="../controller/controllerComunicazioni.php" method="post" enctype="multipart/form-data" >
                                        <input type="text" class="d-none" name="id" value="<?= $comunicazione->getId() ?>">
                                        <input type="text" class="d-none" name="idComponente" value="<?php echo $componente["id"] ?>">
                                        <input type="text" class="d-none" name="operazione" value="modificaComponente">
                                        
                                        <div class="form-row">
                                            <?php 
                                                if($componente["nome"]=="HTML") {
                                            ?>
                                                    <textarea class="form-control" name="testo" rows="10"><?= $componente["testo"] ?></textarea>
                                            <?php
                                                }
                                                else if($componente["nome"]=="Testo") {

                                                    $arrayOpzioni = explode(";",$componente["altreOpzioni"]);
                                            ?>
                                                <textarea class="tiny"  name="testo" rows="10"><?php echo $componente["testo"] ?></textarea>
                                                <small class="form-text text-muted">Attenzione: non tutti i tag HTML sono supportati dai programmi di posta elettronica.</small>
                                            <?php
                                                }
                                                else if($componente["nome"]=="Intestazione") {
                                                    $arrayOpzioni = explode(";",$componente["altreOpzioni"]);

                                            ?>

                                                <div class="form-group col-md-6">
                                                    <label for="inputPassword3">Tipo etichetta</label>
                                                    <select class="form-control" name="opzioneTagH">
                                                    <?php 
                                                        $arrayIntestazioneScelta = explode("=",$arrayOpzioni[0]);
                                                        $intestazioneScelta = str_replace(";","",$arrayIntestazioneScelta[1]);
                                                        $arrayOpzioniH = array("h1","h2","h3","h4","h5","h6");
                                                        foreach($arrayOpzioniH as $elemento) {
                                                            if($intestazioneScelta==$elemento) {
                                                                echo"<option value=\"$elemento\" selected>$elemento</option>";
                                                            }
                                                            else {
                                                                echo"<option value=\"$elemento\">$elemento</option>";
                                                            }
                                                        }
                                                    ?>
                                                    </select>
                                                </div>

                                                <div class="form-group col-md-6">
                                                    <label for="inputPassword3" >Allineamento</label>
                                                    <select class="form-control" name="opzioneAllineamento">
                                                    <?php 
                                                        // codice valido solo fino a quando il c'è un campo
                                                        $arrayOpzioneAllineamento = explode("=",$arrayOpzioni[1]);
                                                        $opzioneAllineamento = str_replace(";","",$arrayOpzioneAllineamento[1]);
                                                        foreach($arrayOpzioniAllineamento as $classe=>$descrizione) {
                                                            if($opzioneAllineamento==$classe) {
                                                                echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                            }
                                                            else {
                                                                echo"<option value=\"$classe\">$descrizione</option>";
                                                            }
                                                        }
                                                    ?>
                                                    </select>
                                                </div>

                                                <div class="form-group col-12">
                                                    <label for="inputPassword3" >Titolo</label>
                                                    <input type="text" class="form-control" name="testo" value="<?php echo $componente["testo"] ?>">
                                                </div>

                                            <?php 
                                                // codice valido solo fino a quando il c'è un campo
                                                if(isset($arrayOpzioni[2])) {
                                                    $arrayOpzioneColore = explode("=",$arrayOpzioni[2]);
                                                    $opzioneColore      = str_replace(";","",$arrayOpzioneColore[1]);
                                                }
                                                else {
                                                    $opzioneColore = "";
                                                }
                                            ?>
                                            <div class="form-group col-md-6">
                                                <label for="inputPassword3" >Colore</label>
                                                <div class="input-group colorpicker-component selettore-colore mb-3">
                                                        <input type="text" id="colore" name="colore" value="<?php echo $opzioneColore ?>" class="form-control" />
                                                        <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                                                </div>
                                            </div>

                                            <?php
                                                }
                                                else if($componente["nome"]=="Immagine") {
                                                    $arrayOpzioni = explode(";",$componente["altreOpzioni"]);

                                            ?>
                                                    <div class="form-group">
                                                        <label for="inputPassword3">Carica file</label>
                                                        <input type="file" class="form-control-file" id="inputFile" name="file" accept="image/*">
                                                    </div>
                                                    <img class="img-fluid w-100 border" src="<?php echo (($componente["testo"]) ? "{$percorsoBase}../{$componente["testo"]}" : "{$percorsoBase}../immagini/altro/segnaposto.png"); ?>" >
                                            <?php
                                                }
                                                else if($componente["nome"]=="Pulsante") {
                                                    $arrayOpzioni = explode(";",$componente["altreOpzioni"]);
                                                    $arrayLink = explode("=",$arrayOpzioni[0]);
                                                    if(isset($arrayLink[1])) {
                                                        $linkPulsante = str_replace(";","",$arrayLink[1]);
                                                    }
                                                    else {
                                                        $linkPulsante  = "";
                                                    }

                                                    // codice valido solo fino a quando il c'è un campo
                                                    if(isset($arrayOpzioni[1])) {
                                                        $arrayOpzioneColore = explode("=",$arrayOpzioni[1]);
                                                        $opzioneColore      = str_replace(";","",$arrayOpzioneColore[1]);
                                                    }
                                                    else {
                                                        $opzioneColore = "";
                                                    }
                                            ?>  
                                                    <div class="form-group col-12">
                                                        <label for="inputPassword3" >Titolo pulsante</label>
                                                        <input type="text" class="form-control" name="testo" value="<?php echo $componente["testo"] ?>">
                                                    </div>

                                                    <div class="form-group col-12">
                                                        <label for="inputPassword3" >Link pulsante</label>
                                                        <input type="text" class="form-control" name="linkPulsante" value="<?php echo $linkPulsante ?>">
                                                    </div>

                                                    <div class="form-group col-md-6">
                                                        <label for="inputPassword3" >Colore</label>
                                                        <div class="input-group colorpicker-component selettore-colore mb-3">
                                                                <input type="text" id="colore" name="colore" value="<?php echo $opzioneColore ?>" class="form-control" />
                                                                <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                                                        </div>
                                                    </div>
                                            <?php 
                                                }
                                            ?>
                                        </div>
                                    </form>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                                    <button type="button" class="btn btn-primary btn-sm" onclick="document.formAggiornaComponente<?php echo $componente["id"]; ?>.submit()"><i class="fas fa-check"></i> Salva</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                }
            }
            include "include/jsBaseAreaAmministrativa.php";
        ?>
        
        <script>

            function inviaComunicazione() {
                document.getElementById("operazione").value = "invia";
                document.formModificaComunicazioni.submit();
            }

            function inviaComunicazioneNuovamente() {
                document.getElementById("operazione").value = "inviaDiNuovo";
                document.formModificaComunicazioni.submit();
            }

            function eliminaComponente(id,immagineComponente,nomeComponente) {
                $('#componenteDaEliminare').val(id);
                document.getElementById("immagineComponenteDaEliminare").src = immagineComponente;
                $('#nomeComponenteDaEliminare').text(nomeComponente);
                $('#modalEliminaComponente').modal('show');
            }
            
            function eseguiEliminazioneComponente() {
                var id = $('#componenteDaEliminare').val();
                $.ajax({
                    type:"GET",
                    url:"../controller/controllerComunicazioni.php",
                    data:{
                        operazione:"eliminaComponente",
                        id:id
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("componenteComunicazione"+id).className = "d-none";
                            $('#modalEliminaComponente').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
                     
            function modificaPosizioneComponenteDaInput(idComponente) {
                var posizione = document.getElementById("posizioneComponente"+idComponente).value;
                modificaPosizioneComponente(idComponente,posizione);
            }
            
            function modificaPosizioneComponente(idComponente,posizione) {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerComunicazioni.php",
                    data:{
                        operazione:"modificaPosizioneComponente",
                        id:<?= $comunicazione->getId() ?>,
                        idComponente:idComponente,
                        posizione:posizione
                    },
                    success:function(esito) {
                        if(esito=="ok") {                
                            aggiornaComponentiComunicazioni();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function cambiaIdElemento(idComponente) {
                var idElemento = $("#idElementoComponente"+idComponente).val();
                
                $.ajax({
                    type:"GET",
                    url:"../controller/controllerComunicazioni.php",
                    data:{
                        operazione:"cambiaIdElemento",
                        id:idComponente,
                        idElemento:idElemento
                    },
                    success:function(result) {
                        if(result=="ok") {
                            $('#labelOperazioneCompletata').text("Elemento aggiornato");
                            $('#modalOperazioneCompletata').modal('show');
                            aggiornaComponentiPagina();
                        }
                        else {
                            alert(result);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaComponentiComunicazioni() {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerComunicazioni.php",
                    data:{
                        operazione:"stampaComponenti",
                        id:<?= $comunicazione->getId() ?>
                    },
                    success:function(codice) {
                        document.getElementById("componentiEmail").innerHTML = codice;
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function inviaMailTest() {
                var destinatario = document.getElementById("mailDestinatario").value;

                if(destinatario.length==0) {
                	alert("Inserisci l'indirizzo a cui inviare l'email di prova");
                }
                else if(destinatario.indexOf("@")<1 || destinatario.indexOf(".")<4) {
                	alert("Inserisci un indirizzo email corretto");
                }
                else {
		        $.ajax({
		            type:"POST",
		            url:"../controller/controllerComunicazioni.php",
		            data:{
		                operazione:"inviaMailDiProva",
		                id:<?= $comunicazione->getId() ?>,
		                destinatario:destinatario
		            },
		            success:function(codice) {
		                document.getElementById("mailDestinatario").value = "";
		                document.getElementById("labelOperazioneCompletata").innerHTML = "Email inviata a "+destinatario;
		                $('#modalOperazioneCompletata').modal('show');
		            },
		            error: function(xhr,status,error) {
		                alert(status+" "+error);
		            }
		        });
                }
            }
            
            function aggiungiRispostaTicket() {
            	document.getElementById("bottoneModalAggiungiRispostaTicket").disabled = true;
            	document.formAggiungiRisposta.submit();
            }
        </script>
        
        <script>
            $('.selectpicker').selectpicker({
            });
        </script>
    </body>
</html>
